package editor;

import game.CustomImageDataII;
import game.IntRect;
import game.RainbowElementalSprite;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;

import javax.imageio.ImageIO;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.event.MouseInputAdapter;

public class EditorCanvas extends JPanel {
	
	
	private BufferedImage backgroundImage;
	
	private RoomEditorPanel layerPanel;
	
	private char[][] staticBlockMap;
	
	private Color backdropColor;
	
	private int canvasWidth, canvasHeight;
	
	private boolean mouseButtonDown = false;

	private Cursor blockBrushCursor;
	private Cursor blockEraserCursor;
	
	private Cursor doorBrushCursor;
	private Cursor crossheirsBrushCursor;
	private Cursor widgetBrushCursor;
	private Cursor widgetEraserCursor;
	private Cursor widgetArrowCursor;
	
	private Cursor radioBrushCursor;
	private Cursor radioEraserCursor;
	private Cursor radioArrowCursor;
	
	private Cursor enemyBrushCursor;
	private Cursor enemyEraserCursor;
	private Cursor enemyArrowCursor;
	
	private Cursor umbrellaBrushCursor;
	private Cursor umbrellaEraserCursor;
	private Cursor umbrellaArrowCursor;
	private Cursor hurtzoneBrushCursor;
	
	private JScrollPane scrollPane;
	
	private Point previousMousePos;
	
	private JPopupMenu mobileObjectPopupMenu;
	private JMenuItem changeMinMaxMenuItem;
	private JMenuItem changeSpeedMenuItem;
	private JMenuItem changeDirectionMenuItem;
	
	private JPopupMenu bossObjectPopupMenu;
	private JMenuItem changeBossFlagPoint;
	private JRadioButtonMenuItem changeBossTypeNoSpawn;
	private JRadioButtonMenuItem changeBossTypeSpawnTwo;
	private JRadioButtonMenuItem changeBossTypeSpawnSix;
	private ButtonGroup changeBossTypeButtonGroup;
	
	private JPopupMenu hurtzonePopupMenu;
	private JMenuItem changeHurtzoneMinMaxMenuItem;
	
	private JPopupMenu doorObjectPopupMenu;
	private JMenuItem doorsShowDestinations;
	
	
	
	
	public EditorCanvas(RoomEditorPanel parent, JScrollPane theScrollPane) {
		super();
		
		layerPanel = parent;
		scrollPane = theScrollPane;
		
		this.setMaximumSize(new Dimension(1000, 700));
		this.setMinimumSize(new Dimension(1000, 700));
		this.setPreferredSize(new Dimension(1000, 700));
		
		try {
			backgroundImage = ImageIO.read(EditorCanvas.class.getResource("/images/spectrum_test.GIF"));
		} catch (IOException e) {
			// TODO Auto-generated catch block
//			e.printStackTrace();
		}
		
		this.addMouseListener(new MouseInputAdapter() {
			public void mouseClicked(MouseEvent e) {
				JOptionPane.showMessageDialog(null, "Click happened at: " + e.getX() + ", " + e.getY());
			}
			public void mouseMoved(MouseEvent e) {
				if(mouseButtonDown)
					drawStaticBlockOntoCanvas(e);
			}
		});
		
		
		
		
		
		
		
	}
	
	
	public void paintComponent(Graphics g) {
		super.paintComponent(g);
		
		Color origColor = g.getColor();
		
		
		Color outOfBoundsColor = layerPanel.getStaticBlockFactory().getOutOfBoundsColor();
		
		//System.out.println("<><>DELME outOfBoundsColor is:  " + (outOfBoundsColor == null ? "null" : (outOfBoundsColor.getRed() + "," + outOfBoundsColor.getGreen() + "," + outOfBoundsColor.getBlue())));
		
		g.setColor(outOfBoundsColor);
		g.fillRect(0, 0, this.getSize().width, this.getSize().height);
		
		
		
		
		if(backdropColor != null) {
			g.setColor(backdropColor);
			g.fillRect(0, 0, canvasWidth, canvasHeight);
		}
		
		//g.drawImage(backgroundImage, 0, 0, canvasWidth, canvasHeight, this);
		
		
		if(layerPanel.getBackgroundImage() != null && layerPanel.getLayerControlPanel().shouldShowBackground()) {
			Point p = determineCenterOfViewport();
			layerPanel.getBackgroundImage().drawObjectIgnoreBounds(g, p.x, p.y);
		}
		
		g.setColor(outOfBoundsColor);
		if(canvasWidth < scrollPane.getWidth() || canvasWidth < this.getWidth()) {
			g.fillRect(canvasWidth + 1, 0, Math.max(this.getWidth(), scrollPane.getWidth()), Math.max(this.getHeight(), scrollPane.getHeight()));
		}
		if(canvasHeight < scrollPane.getHeight() || canvasHeight < this.getHeight()) {
			g.fillRect(0, canvasHeight + 1, Math.max(this.getWidth(), scrollPane.getWidth()), Math.max(this.getHeight(), scrollPane.getHeight()));
		}
		
		if(layerPanel.getForegroundImage() != null && layerPanel.getLayerControlPanel().shouldShowForeground()) {
			layerPanel.getForegroundImage().drawObjectFromUpperLeftCorner(g, 0, 0);
		}
		
		StaticBlockCanvasObject tempSBCO;
		
		if(staticBlockMap != null && layerPanel != null 
				&& layerPanel.getCharactersToBlocks() != null
				&& layerPanel.getStaticBlockFactory() != null
				&& layerPanel.getLayerControlPanel().shouldShowStaticBlocks()) {
			for(int y = 0; y < staticBlockMap.length; y++) {
				
				for(int x = 0; x < staticBlockMap[y].length; x++) {
					
					
					tempSBCO = layerPanel.getCharactersToBlocks().get(staticBlockMap[y][x]);
					
					if(tempSBCO != null) {
						tempSBCO.getImage().drawObjectFromUpperLeftCorner(g, x * layerPanel.getStaticBlockFactory().getTileWidth(), y * layerPanel.getStaticBlockFactory().getTileHeight());
					}
					
				}
				
			}
		}
		
		if(layerPanel != null && layerPanel.getLayerControlPanel().shouldShowWidgetsDoorsAndItems()) {
			
			ArrayList<ScreenObject> screenObjects = layerPanel.getDoorLayerScreenObjects();
			
			for(ScreenObject so : screenObjects) {
				so.draw(g);
				
			}
			
		}
		
		
		if(layerPanel != null && layerPanel.getLayerControlPanel().shouldShowCommentaryOnlyObjects()) {
			
			ArrayList<ScreenObject> screenObjects = layerPanel.getCommentaryLayerScreenObjects();
			
			for(ScreenObject so : screenObjects) {
				so.draw(g);
			}
			
		}
		
		
		if(layerPanel != null && layerPanel.getLayerControlPanel().shouldShowEnemiesAndMovingBlocks()) {
			
			ArrayList<ScreenObject> screenObjects = layerPanel.getEnemyLayerScreenObjects();
			
			for(ScreenObject so : screenObjects) {
				so.draw(g);
				
			}
			
		}
		
		if(layerPanel != null && layerPanel.getLayerControlPanel().shouldShowForegroundWidgets()) {
			
			ArrayList<ScreenObject> screenObjects = layerPanel.getWidgetLayerScreenObjects();
			
			for(ScreenObject so : screenObjects) {
				so.draw(g);
				
			}
			
		}
		
		
	}
	
	
	
	public void setAllSizes(int newWidth, int newHeight) {
		this.setMaximumSize(new Dimension(newWidth, newHeight));
		this.setMinimumSize(new Dimension(newWidth, newHeight));
		this.setPreferredSize(new Dimension(newWidth, newHeight));
	}
	
	
	

	public JScrollPane getScrollPane() {
		return scrollPane;
	}


	public void setScrollPane(JScrollPane scrollPane) {
		this.scrollPane = scrollPane;
		
		scrollPane.addKeyListener(new KeyAdapter() {
			@Override
			public void keyPressed(KeyEvent arg0) {
//				System.out.println("<><>DELME got a key event in the scroll pane!");
			}
		}) ;
		
	}


	public EditorCanvas(NewRoomData wizard, RoomEditorPanel theParent) {
		super();
		
		
		layerPanel = theParent;
		
		layerPanel.setStaticBlockFactory(new StaticBlockCanvasObjectFactory(wizard, this));
		
		canvasWidth = wizard.getTileWidth() * wizard.getRoomWidth();
		canvasHeight = wizard.getTileHeight() * wizard.getRoomHeight();
		
		backdropColor = Color.white;
		
		this.setMaximumSize(new Dimension(canvasWidth, canvasHeight));
		this.setMinimumSize(new Dimension(canvasWidth, canvasHeight));
		this.setPreferredSize(new Dimension(canvasWidth, canvasHeight));
		
		
		staticBlockMap = new char[wizard.getRoomHeight()][];
		
		for(int y = 0; y < staticBlockMap.length; y++) {
			staticBlockMap[y] = new char[wizard.getRoomWidth()];
			for(int x = 0; x < staticBlockMap[y].length; x++) {
				staticBlockMap[y][x] = ' ';
			}
		}
		
		
		this.addKeyListener(new KeyAdapter() {
			@Override
			public void keyPressed(KeyEvent arg0) {
//				System.out.println("<><>DELME got a key event in the canvas!");
			}
		}) ;
		
		
		MouseInputAdapter mouseAdapter = new MouseInputAdapter() {
			@Override
			public void mousePressed(MouseEvent e) {
				if(e.getButton() == MouseEvent.BUTTON1) {
					mouseButtonDown = true;
					dragHappenedOnCanvas(e);
					previousMousePos = new Point(e.getX(), e.getY());
				}
			}
			
			@Override
			public void mouseReleased(MouseEvent e) {
				if(e.getButton() == MouseEvent.BUTTON1) {
					mouseButtonDown = false;
					previousMousePos = null;
				}
				if((e.isPopupTrigger() || e.getButton() == MouseEvent.BUTTON2 || e.getButton() == MouseEvent.BUTTON3) 
						&& layerPanel != null 
						&& layerPanel.getLayerControlPanel() != null
						&& layerPanel.getLayerControlPanel().getCurrentLayer() == LayerControlPanel.ENEMY_LAYER) {
					rightClickOnEnemyLevel(e);
				}
			}
			
			
			
			@Override
			public void mouseDragged(MouseEvent e) {
				dragHappenedOnCanvas(e);
				previousMousePos = new Point(e.getX(), e.getY());
			}
			
			@Override
			public void mouseMoved(MouseEvent e) {
				if(mouseButtonDown)
					dragHappenedOnCanvas(e);
				moveHappenedOnCanvas(e);
			}
			
			@Override
			public void mouseClicked(MouseEvent e) {
				clickHappenedOnCanvas(e);
			}
			
		};
		
		this.addMouseListener(mouseAdapter);
		this.addMouseMotionListener(mouseAdapter);
		
		
		mobileObjectPopupMenu = new JPopupMenu();
		changeMinMaxMenuItem = new JMenuItem("Change min/max");
		changeMinMaxMenuItem.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent arg0) {
//				System.out.println("now in actionperformed!");
				readjustMobileObjects();
			}
			
		});
		mobileObjectPopupMenu.add(changeMinMaxMenuItem);
		
		changeSpeedMenuItem = new JMenuItem("Change Speed...");
		changeSpeedMenuItem.addActionListener(new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent e) {
//				System.out.println("now in actionPerformed for the change speed thingy!");
				changeSpeedOnMobileObject();
			}
		});
		mobileObjectPopupMenu.add(changeSpeedMenuItem);
		
		changeDirectionMenuItem = new JMenuItem("Change Direction");
		changeDirectionMenuItem.addActionListener(new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent arg0) {
				changeDirectionOnMobileObject();
			}
		});
		mobileObjectPopupMenu.add(changeDirectionMenuItem);
		
		
		bossObjectPopupMenu = new JPopupMenu();
		
		changeBossFlagPoint = new JMenuItem("Change Boss Flag Position");
		changeBossFlagPoint.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
//				System.out.println("placeholder for flag position change");
				
				RainbowBossScreenPaletteObject po = layerPanel.getEditorPalette().setSelectedObjectToRainbowElemental();
				if(po == null)
					return;
				
				po.setSettingFlagPos(true);
				
				po.getCreatedObject().setSelected(false);
				
			}
		});
		bossObjectPopupMenu.add(changeBossFlagPoint);
		
		changeBossTypeNoSpawn = new JRadioButtonMenuItem("Boss Type:  No Spawning");
		changeBossTypeNoSpawn.setSelected(true);
		changeBossTypeNoSpawn.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				RainbowBossScreenPaletteObject po = layerPanel.getEditorPalette().setSelectedObjectToRainbowElemental();
				if(po == null)
					return;
				RainbowBossScreenObject so = po.getCreatedObject();
				if(so == null)
					return;
				so.setType(RainbowElementalSprite.NO_SPAWNING);
				layerPanel.repaint();
			}
		});
		bossObjectPopupMenu.add(changeBossTypeNoSpawn);
		
		changeBossTypeSpawnTwo = new JRadioButtonMenuItem("Boss Type:  Spawn Two Enemies");
		changeBossTypeSpawnTwo.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				RainbowBossScreenPaletteObject po = layerPanel.getEditorPalette().setSelectedObjectToRainbowElemental();
				if(po == null)
					return;
				RainbowBossScreenObject so = po.getCreatedObject();
				if(so == null)
					return;
				so.setType(RainbowElementalSprite.SPAWN_TWO);
				layerPanel.repaint();
			}
		});
		bossObjectPopupMenu.add(changeBossTypeSpawnTwo);
		
		changeBossTypeSpawnSix = new JRadioButtonMenuItem("Boss Type:  Spawn Six Enemies");
		changeBossTypeSpawnSix.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				RainbowBossScreenPaletteObject po = layerPanel.getEditorPalette().setSelectedObjectToRainbowElemental();
				if(po == null)
					return;
				RainbowBossScreenObject so = po.getCreatedObject();
				if(so == null)
					return;
				so.setType(RainbowElementalSprite.SPAWN_SIX);
				layerPanel.repaint();
			}
		});
		bossObjectPopupMenu.add(changeBossTypeSpawnSix);
		
		changeBossTypeButtonGroup = new ButtonGroup();
		changeBossTypeButtonGroup.add(changeBossTypeNoSpawn);
		changeBossTypeButtonGroup.add(changeBossTypeSpawnTwo);
		changeBossTypeButtonGroup.add(changeBossTypeSpawnSix);
		
		
		hurtzonePopupMenu = new JPopupMenu();
		changeHurtzoneMinMaxMenuItem = new JMenuItem("Change min/max");
		changeHurtzoneMinMaxMenuItem.addActionListener(new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent e) {
				readjustMobileObjects();
			}
		});
		hurtzonePopupMenu.add(changeHurtzoneMinMaxMenuItem);
		
		
		
		doorObjectPopupMenu = new JPopupMenu();
		doorsShowDestinations = new JCheckBoxMenuItem("Doors Show Destinations/Souces?");
		doorsShowDestinations.setSelected(true);
		doorsShowDestinations.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				layerPanel.repaint();
			}
		});
		doorObjectPopupMenu.add(doorsShowDestinations);
		
		
		GraphicsEnvironment gm = GraphicsEnvironment.getLocalGraphicsEnvironment();
		GraphicsConfiguration gc = gm.getDefaultScreenDevice().getDefaultConfiguration();
		
		BufferedImage tempImage = null; 
		BufferedImage tempBuffer = null;
		Point point = null;
		
		point = new Point(0, 0);
		
		try {
			tempImage = ImageIO.read(RoomEditorPanel.class.getResource("/images/blockbrush.GIF"));//ImageIO.read(TetrominoesPanel.class.getResource("../images/leftI.GIF"));
			tempImage = CustomImageDataII.makeImageTransparent(tempImage, Color.magenta);
			tempBuffer = gc.createCompatibleImage(32, 32, BufferedImage.TYPE_INT_ARGB);
			tempBuffer.createGraphics().drawImage(tempImage, 0,0,null, this);
			blockBrushCursor = Toolkit.getDefaultToolkit().createCustomCursor(tempBuffer, point, "");
		} catch(Exception e) {
//			e.printStackTrace();
		}
		
		try {
			tempImage = ImageIO.read(RoomEditorPanel.class.getResource("/images/eraseBlock.GIF"));//ImageIO.read(TetrominoesPanel.class.getResource("../images/leftI.GIF"));
			tempImage = CustomImageDataII.makeImageTransparent(tempImage, Color.magenta);
			tempBuffer = gc.createCompatibleImage(32, 32, BufferedImage.TYPE_INT_ARGB);
			tempBuffer.createGraphics().drawImage(tempImage, 0,0,null, this);
			blockEraserCursor = Toolkit.getDefaultToolkit().createCustomCursor(tempBuffer, point, "");
		} catch(Exception e) {
//			e.printStackTrace();
		}
		
		try {
			tempImage = ImageIO.read(RoomEditorPanel.class.getResource("/images/widgetbrush.GIF"));//ImageIO.read(TetrominoesPanel.class.getResource("../images/leftI.GIF"));
			tempImage = CustomImageDataII.makeImageTransparent(tempImage, Color.magenta);
			tempBuffer = gc.createCompatibleImage(32, 32, BufferedImage.TYPE_INT_ARGB);
			tempBuffer.createGraphics().drawImage(tempImage, 0,0,null, this);
			widgetBrushCursor = Toolkit.getDefaultToolkit().createCustomCursor(tempBuffer, point, "");
		} catch(Exception e) {
//			e.printStackTrace();
		}
		
		
		try {
			tempImage = ImageIO.read(RoomEditorPanel.class.getResource("/images/doorbrush.GIF"));//ImageIO.read(TetrominoesPanel.class.getResource("../images/leftI.GIF"));
			tempImage = CustomImageDataII.makeImageTransparent(tempImage, Color.magenta);
			tempBuffer = gc.createCompatibleImage(32, 32, BufferedImage.TYPE_INT_ARGB);
			tempBuffer.createGraphics().drawImage(tempImage, 0,0,null, this);
			doorBrushCursor = Toolkit.getDefaultToolkit().createCustomCursor(tempBuffer, point, "");
		} catch(Exception e) {
//			e.printStackTrace();
		}
		
		try {
			tempImage = ImageIO.read(RoomEditorPanel.class.getResource("/images/crossheirsbrush.GIF"));//ImageIO.read(TetrominoesPanel.class.getResource("../images/leftI.GIF"));
			tempImage = CustomImageDataII.makeImageTransparent(tempImage, Color.magenta);
			tempBuffer = gc.createCompatibleImage(32, 32, BufferedImage.TYPE_INT_ARGB);
			tempBuffer.createGraphics().drawImage(tempImage, 0,0,null, this);
			crossheirsBrushCursor = Toolkit.getDefaultToolkit().createCustomCursor(tempBuffer, point, "");
		} catch(Exception e) {
//			e.printStackTrace();
		}
		
		
		try {
			tempImage = ImageIO.read(RoomEditorPanel.class.getResource("/images/eraseWidget.GIF"));//ImageIO.read(TetrominoesPanel.class.getResource("../images/leftI.GIF"));
			tempImage = CustomImageDataII.makeImageTransparent(tempImage, Color.magenta);
			tempBuffer = gc.createCompatibleImage(32, 32, BufferedImage.TYPE_INT_ARGB);
			tempBuffer.createGraphics().drawImage(tempImage, 0,0,null, this);
			widgetEraserCursor = Toolkit.getDefaultToolkit().createCustomCursor(tempBuffer, point, "");
		} catch(Exception e) {
//			e.printStackTrace();
		}
		
		try {
			tempImage = ImageIO.read(RoomEditorPanel.class.getResource("/images/widgetselect.GIF"));//ImageIO.read(TetrominoesPanel.class.getResource("../images/leftI.GIF"));
			tempImage = CustomImageDataII.makeImageTransparent(tempImage, Color.magenta);
			tempBuffer = gc.createCompatibleImage(32, 32, BufferedImage.TYPE_INT_ARGB);
			tempBuffer.createGraphics().drawImage(tempImage, 0,0,null, this);
			widgetArrowCursor = Toolkit.getDefaultToolkit().createCustomCursor(tempBuffer, point, "");
		} catch(Exception e) {
//			e.printStackTrace();
		}
		
		
		
		try {
			tempImage = ImageIO.read(RoomEditorPanel.class.getResource("/images/radioBrush.GIF"));//ImageIO.read(TetrominoesPanel.class.getResource("../images/leftI.GIF"));
			tempImage = CustomImageDataII.makeImageTransparent(tempImage, Color.magenta);
			tempBuffer = gc.createCompatibleImage(32, 32, BufferedImage.TYPE_INT_ARGB);
			tempBuffer.createGraphics().drawImage(tempImage, 0,0,null, this);
			radioBrushCursor = Toolkit.getDefaultToolkit().createCustomCursor(tempBuffer, point, "");
		} catch(Exception e) {
//			e.printStackTrace();
		}
		
		try {
			tempImage = ImageIO.read(RoomEditorPanel.class.getResource("/images/erase radio.GIF"));//ImageIO.read(TetrominoesPanel.class.getResource("../images/leftI.GIF"));
			tempImage = CustomImageDataII.makeImageTransparent(tempImage, Color.magenta);
			tempBuffer = gc.createCompatibleImage(32, 32, BufferedImage.TYPE_INT_ARGB);
			tempBuffer.createGraphics().drawImage(tempImage, 0,0,null, this);
			radioEraserCursor = Toolkit.getDefaultToolkit().createCustomCursor(tempBuffer, point, "");
		} catch(Exception e) {
//			e.printStackTrace();
		}
		
		try {
			tempImage = ImageIO.read(RoomEditorPanel.class.getResource("/images/selectRadio.GIF"));//ImageIO.read(TetrominoesPanel.class.getResource("../images/leftI.GIF"));
			tempImage = CustomImageDataII.makeImageTransparent(tempImage, Color.magenta);
			tempBuffer = gc.createCompatibleImage(32, 32, BufferedImage.TYPE_INT_ARGB);
			tempBuffer.createGraphics().drawImage(tempImage, 0,0,null, this);
			radioArrowCursor = Toolkit.getDefaultToolkit().createCustomCursor(tempBuffer, point, "");
		} catch(Exception e) {
//			e.printStackTrace();
		}
		
		

		try {
			tempImage = ImageIO.read(RoomEditorPanel.class.getResource("/images/mobBlockSelect.GIF"));//ImageIO.read(TetrominoesPanel.class.getResource("../images/leftI.GIF"));
			tempImage = CustomImageDataII.makeImageTransparent(tempImage, Color.magenta);
			tempBuffer = gc.createCompatibleImage(32, 32, BufferedImage.TYPE_INT_ARGB);
			tempBuffer.createGraphics().drawImage(tempImage, 0,0,null, this);
			enemyArrowCursor = Toolkit.getDefaultToolkit().createCustomCursor(tempBuffer, point, "");
		} catch(Exception e) {
//			e.printStackTrace();
		}

		try {
			tempImage = ImageIO.read(RoomEditorPanel.class.getResource("/images/mobBlockBrush.GIF"));//ImageIO.read(TetrominoesPanel.class.getResource("../images/leftI.GIF"));
			tempImage = CustomImageDataII.makeImageTransparent(tempImage, Color.magenta);
			tempBuffer = gc.createCompatibleImage(32, 32, BufferedImage.TYPE_INT_ARGB);
			tempBuffer.createGraphics().drawImage(tempImage, 0,0,null, this);
			enemyBrushCursor = Toolkit.getDefaultToolkit().createCustomCursor(tempBuffer, point, "");
		} catch(Exception e) {
//			e.printStackTrace();
		}

		try {
			tempImage = ImageIO.read(RoomEditorPanel.class.getResource("/images/mobBlockErase.GIF"));//ImageIO.read(TetrominoesPanel.class.getResource("../images/leftI.GIF"));
			tempImage = CustomImageDataII.makeImageTransparent(tempImage, Color.magenta);
			tempBuffer = gc.createCompatibleImage(32, 32, BufferedImage.TYPE_INT_ARGB);
			tempBuffer.createGraphics().drawImage(tempImage, 0,0,null, this);
			enemyEraserCursor = Toolkit.getDefaultToolkit().createCustomCursor(tempBuffer, point, "");
		} catch(Exception e) {
//			e.printStackTrace();
		}
		
		
		
		
		
		try {
			tempImage = ImageIO.read(RoomEditorPanel.class.getResource("/images/brellabrush.GIF"));
			tempImage = CustomImageDataII.makeImageTransparent(tempImage, Color.magenta);
			tempBuffer = gc.createCompatibleImage(32, 32, BufferedImage.TYPE_INT_ARGB);
			tempBuffer.createGraphics().drawImage(tempImage, 0,0,null, this);
			umbrellaBrushCursor = Toolkit.getDefaultToolkit().createCustomCursor(tempBuffer, point, "");
		} catch(Exception e) {
//			e.printStackTrace();
		}
		
		try {
			tempImage = ImageIO.read(RoomEditorPanel.class.getResource("/images/erase brella.GIF"));
			tempImage = CustomImageDataII.makeImageTransparent(tempImage, Color.magenta);
			tempBuffer = gc.createCompatibleImage(32, 32, BufferedImage.TYPE_INT_ARGB);
			tempBuffer.createGraphics().drawImage(tempImage, 0,0,null, this);
			umbrellaEraserCursor = Toolkit.getDefaultToolkit().createCustomCursor(tempBuffer, point, "");
		} catch(Exception e) {
//			e.printStackTrace();
		}
		
		try {
			tempImage = ImageIO.read(RoomEditorPanel.class.getResource("/images/selectbrella.GIF"));
			tempImage = CustomImageDataII.makeImageTransparent(tempImage, Color.magenta);
			tempBuffer = gc.createCompatibleImage(32, 32, BufferedImage.TYPE_INT_ARGB);
			tempBuffer.createGraphics().drawImage(tempImage, 0,0,null, this);
			umbrellaArrowCursor = Toolkit.getDefaultToolkit().createCustomCursor(tempBuffer, point, "");
		} catch(Exception e) {
//			e.printStackTrace();
		}
		
		
		try {
			tempImage = ImageIO.read(RoomEditorPanel.class.getResource("/images/hurtzonebrush.GIF"));
			tempImage = CustomImageDataII.makeImageTransparent(tempImage, Color.magenta);
			tempBuffer = gc.createCompatibleImage(32, 32, BufferedImage.TYPE_INT_ARGB);
			tempBuffer.createGraphics().drawImage(tempImage, 0,0,null, this);
			hurtzoneBrushCursor = Toolkit.getDefaultToolkit().createCustomCursor(tempBuffer, point, "");
		} catch(Exception e) {
//			e.printStackTrace();
		}
		
	}
	
	
	
	private void rightClickOnWidgetLevel(MouseEvent e) {
//		System.out.println("now in rightClickOnEnemyLevel");
		
		boolean boolArray[] = checkToSeeIfMinMaxShouldBeEnabled();
		
		boolean shouldNotBeGrayed = boolArray[0];
		boolean hasSpeed = boolArray[1];
		
		
		if(shouldNotBeGrayed) {
			hurtzonePopupMenu.show(this, e.getX(), e.getY());
		}
		
	}
	
	
	private void dragOnForegroundWidgetLevel(MouseEvent e) {
		
		if(previousMousePos == null || !(layerPanel.getEditorPalette().getCurrentSelection() instanceof ObjectSelectPaletteObject))
			return;
		
		Point currentMousePos = new Point(e.getX(), e.getY());
		
		int xMove = currentMousePos.x - previousMousePos.x;
		int yMove = currentMousePos.y - previousMousePos.y;
		
		ArrayList<ScreenObject> selectedObjects = new ArrayList<ScreenObject>();
		
		ScreenObject so = null;
		
		for(int i = 0; i < layerPanel.getWidgetLayerScreenObjects().size(); i++) {
			so = layerPanel.getWidgetLayerScreenObjects().get(i);
			if(so.isSelected()) {
				if(so instanceof MobileScreenObject) {
					((MobileScreenObject)so).move(xMove, yMove);
				} else {
					so.getClickRect().move(xMove, yMove);
				}
			}
		}
		
		layerPanel.repaint();
	}
	
	private void drawForegroundWidgetOntoCanvas(MouseEvent e) {
		
//		System.out.println("now in drawForegroundWidgetOntoCanvas");
		
		
		if(e.isPopupTrigger() || e.getButton() == MouseEvent.BUTTON2 || e.getButton() == MouseEvent.BUTTON3) {
			rightClickOnWidgetLevel(e);
			return;
		}
		
		
		
		PaletteObject paletteObject = layerPanel.getEditorPalette().getCurrentSelection();
		Point pt = new Point(e.getX(), e.getY());
		
		if(paletteObject == null) {
//			System.out.println("bleh!  returning...");
			return;
		}
		
		
		
		if(paletteObject instanceof StaticBlockPaletteObject && ((StaticBlockPaletteObject)paletteObject).getBlockChar() == ' ') {
			
//			System.out.println("about to erase at " + e.getX() + ", " + e.getY());
			
			
			ArrayList<ScreenObject> candidatesForErasure = new ArrayList<ScreenObject>();
			ArrayList<ScreenObject> allScreenObjects = layerPanel.getWidgetLayerScreenObjects();
			ArrayList<Integer> indexesForErasure = new ArrayList<Integer>();
			for(int i = 0; i < allScreenObjects.size(); i++) {
				if(allScreenObjects.get(i).getClickRect().contains(pt)) {
					candidatesForErasure.add(allScreenObjects.get(i));
					indexesForErasure.add(i);
				}
			}
			
//			System.out.println("BEFORE   size of allScreenObjects: " + allScreenObjects.size() + ", size of indexesForErasure: " + indexesForErasure.size() + ", size of allScreenObjects: " + allScreenObjects.size());
			
			if(indexesForErasure.size() == 1) {
				allScreenObjects.remove(indexesForErasure.get(0).intValue());
//				System.out.println("only erased one.");
				
				
			} else if(indexesForErasure.size() == 0) {
//				System.out.println("it was empty!");
				
			} else {
			
				int indexesToBeErased [] = DeleteSelectionWizard.selectDeletableObjects(indexesForErasure, candidatesForErasure);
				
				if(indexesToBeErased == null) {
//					System.out.println("indexes to be erased was null!");
					return;
				}
				
				//TODO:  make the user select an object from the candidate list
				for(int i = indexesToBeErased.length - 1; i >= 0; i--) {
					if(allScreenObjects.get(indexesToBeErased[i]) instanceof WidgetScreenObject) {
						((WidgetScreenObject) allScreenObjects.get(indexesToBeErased[i])).getPaletteObject().delete(allScreenObjects.get(indexesToBeErased[i]));
					}
					allScreenObjects.remove(indexesToBeErased[i]);
				}
			}
			
//			System.out.println("AFTER   size of allScreenObjects: " + allScreenObjects.size() + ", size of indexesForErasure: " + indexesForErasure.size() + ", size of allScreenObjects: " + allScreenObjects.size());
			
		} else if(paletteObject instanceof MobileScreenPaletteObject) {
			
			MobileScreenPaletteObject mpo = (MobileScreenPaletteObject) paletteObject;
			
			MobileScreenObject mso = mpo.getConstructedObject();
			
			
			switch(mpo.getMode()) {
			case MobileScreenPaletteObject.DEFAULT:
				mso = (MobileScreenObject) mpo.create(e.getX(), e.getY(), this);
				layerPanel.getWidgetLayerScreenObjects().add(mso);
				break;
			case MobileScreenPaletteObject.SETTING_MIN:
				mpo.setMode(MobileScreenPaletteObject.SETTING_MAX);
				break;
			case MobileScreenPaletteObject.SETTING_MAX:
				mpo.setMode(MobileScreenPaletteObject.DEFAULT);
				if(mpo.isSettingFromSelector()) {
					mpo.setSettingFromSelector(false);
					layerPanel.getEditorPalette().setSelectionToSelector();
				}
				break;
			}
			
//			System.out.println("at the end the mode is: " + mpo.getMode());
		} else if(paletteObject instanceof WidgetScreenPaletteObject) {
			WidgetScreenObject newbie = (WidgetScreenObject) ((WidgetScreenPaletteObject) paletteObject).create(e.getX(), e.getY(), this);
			layerPanel.getWidgetLayerScreenObjects().add(newbie);
//			System.out.println("about to add a widget at " + e.getX() + ", " + e.getY());
		} else if(paletteObject instanceof ObjectSelectPaletteObject) {
			
			ScreenObject so;
			
			if(!e.isControlDown()) {
				layerPanel.unselectEverything();
			}
			
			 for(int i =0; i < layerPanel.getWidgetLayerScreenObjects().size(); i++) {
				 so = layerPanel.getWidgetLayerScreenObjects().get(i);
				 if(so.getClickRect().contains(pt)) {
					 so.setSelected(!so.isSelected());
				 }
			 }
			
		} else if(paletteObject instanceof GoalScreenPaletteObject) {
			
			ScreenObject newbie = ((GoalScreenPaletteObject) paletteObject).create(e.getX(), e.getY(), this);
			if(newbie == null) {
				JOptionPane.showMessageDialog(null, "There can only be one goal per room, sorry.","Warning", JOptionPane.WARNING_MESSAGE);
			} else {
				layerPanel.getWidgetLayerScreenObjects().add(newbie);
			}
			
			
		} else if(paletteObject instanceof LevelStartPaletteObject) {
			
			if(((LevelStartPaletteObject) paletteObject).screenObjectAlreadyExists()) {
				JOptionPane.showMessageDialog(this, "Only one level starting point per room is allowed, and there is already a starting point in this room.  (Note that this starting point will do nothing unless this is marked as the starting room.)","Unable to create", JOptionPane.WARNING_MESSAGE);
				return;
			} else {
				LevelStartScreenObject newbie = (LevelStartScreenObject) ((LevelStartPaletteObject) paletteObject).create(e.getX(), e.getY(), this);
				layerPanel.getWidgetLayerScreenObjects().add(newbie);
			}
			
		}
		
		ArrayMoveOver.ensureOrderIntegrity(layerPanel.getWidgetLayerScreenObjects());
		
		layerPanel.repaint();
		layerPanel.getListItem().updateIconAndColor();
		
	}
	
	
	
	private boolean[] checkToSeeIfMinMaxShouldBeEnabled() {
		ArrayList<ScreenObject> selectedObjects = layerPanel.getSelectedObjects();
		if(selectedObjects == null || selectedObjects.size() != 1 || !(selectedObjects.get(0) instanceof MobileScreenObject))
			return new boolean[]{false, false};
		
		if(selectedObjects.get(0) instanceof VerticalBlockScreenObject || selectedObjects.get(0) instanceof HorizontalBlockScreenObject)
			return new boolean[]{true, true};
		
		return new boolean[]{true, false};
	}
	
	private void changeDirectionOnMobileObject() {
		
		ArrayList<ScreenObject> selectedObjects = layerPanel.getSelectedObjects();
		if(selectedObjects == null || selectedObjects.size() != 1 || !(selectedObjects.get(0) instanceof MobileScreenObject))
			return;
		
		MobileScreenObject mso = (MobileScreenObject) selectedObjects.get(0);
		
//		System.out.println("mso is of type: " + mso.getClass().getCanonicalName() + ", direction? " + mso.isGoingMinDirection());
		
		
		mso.setGoingMinDirection(!mso.isGoingMinDirection());
		
		
//		System.out.println("and after, mso is of type: " + mso.getClass().getCanonicalName() + ", direction? " + mso.isGoingMinDirection());
		
		layerPanel.repaint();
		
	}
	
	private void changeSpeedOnMobileObject() {
		
		ArrayList<ScreenObject> selectedObjects = layerPanel.getSelectedObjects();
		if(selectedObjects == null || selectedObjects.size() != 1 || !(selectedObjects.get(0) instanceof MobileScreenObject))
			return;
		
		MobileScreenObject mso = (MobileScreenObject) selectedObjects.get(0);
		
		String newSpeedStr = JOptionPane.showInputDialog("Input new speed: ",Integer.toString(mso.getSpeed()));
		
		if(newSpeedStr == null)
			return;
		
		try {
			int newSpeedInt = Integer.parseInt(newSpeedStr.trim());
			mso.setSpeed(newSpeedInt);
		} catch (NumberFormatException e) {
			JOptionPane.showMessageDialog(this, "Error:  " + newSpeedStr + " is not a number.","Error Occurred", JOptionPane.ERROR_MESSAGE);
		}
		
	}
	
	private void readjustMobileObjects() {
		
//		System.out.println("BEFORE about to sound off...");
//		layerPanel.getEditorPalette().soundOffEnemyLayerPaletteContents();
		
		ArrayList<ScreenObject> selectedObjects = layerPanel.getSelectedObjects();
		if(selectedObjects == null || selectedObjects.size() != 1 || !(selectedObjects.get(0) instanceof MobileScreenObject))
			return;
		
		MobileScreenObject mso = (MobileScreenObject) selectedObjects.get(0);
		
		MobileScreenPaletteObject mpo = mso.getPaletteObject();
		
		layerPanel.unselectEverything();
		
//		System.out.println("MIDDLE about to sound off...");
//		layerPanel.getEditorPalette().soundOffEnemyLayerPaletteContents();
		layerPanel.getEditorPalette().unselectEverything();
		layerPanel.getEditorPalette().setSelectedObject(mpo);
		
		mpo.setSelected(true);
		mpo.setMode(MobileScreenPaletteObject.SETTING_MIN);
		mpo.setConstructedObject(mso);
		mpo.setSettingFromSelector(true);
		
		this.repaint();
		

//		System.out.println("AFTER about to sound off...");
//		layerPanel.getEditorPalette().soundOffEnemyLayerPaletteContents();
		
	}
	
	private void moveHappenedOnCanvas(MouseEvent e) {
		switch(layerPanel.getLayerControlPanel().getCurrentLayer()) {
		case LayerControlPanel.BLOCK_LAYER:
			break;
		case LayerControlPanel.DOOR_LAYER:
			break;
		case LayerControlPanel.ENEMY_LAYER:
		case LayerControlPanel.WIDGET_LAYER:
			moveOnEnemyOrWidgetLevel(e);
			break;
		
			
		}
	}
	
	private void dragHappenedOnCanvas(MouseEvent e) {
		
		switch(layerPanel.getLayerControlPanel().getCurrentLayer()) {
		case LayerControlPanel.BLOCK_LAYER:
			drawStaticBlockOntoCanvas(e);
			break;
		case LayerControlPanel.DOOR_LAYER:
			dragOnDoorWidgetItemLevel(e);
			break;
		case LayerControlPanel.COMMENTARY_LAYER:
			dragOnCommentLevel(e);
			break;
		case LayerControlPanel.ENEMY_LAYER:
			dragOnEnemyLevel(e);
			break;
		case LayerControlPanel.WIDGET_LAYER:
			dragOnForegroundWidgetLevel(e);
			break;
		}
		
	}
	
	
	private void clickHappenedOnCanvas(MouseEvent e) {
		
		switch(layerPanel.getLayerControlPanel().getCurrentLayer()) {
		case LayerControlPanel.BLOCK_LAYER:
			drawStaticBlockOntoCanvas(e);
			break;
		case LayerControlPanel.DOOR_LAYER:
			drawDoorWidgetItemOntoCanvas(e);
			break;
		case LayerControlPanel.COMMENTARY_LAYER:
			drawOnCommentLevel(e);
			break;
		case LayerControlPanel.ENEMY_LAYER:
			clickOnEnemyLevel(e);
			break;
		case LayerControlPanel.WIDGET_LAYER:
			drawForegroundWidgetOntoCanvas(e);
			break;
		}
		
	}
	
	
	

	private void dragOnCommentLevel(MouseEvent e) {
//		System.out.println("drag on comment level!");
		
		if(previousMousePos == null || (layerPanel.getEditorPalette().getCurrentSelection() != null && !(layerPanel.getEditorPalette().getCurrentSelection() instanceof ObjectSelectPaletteObject))) {
			//System.out.println("previousMousePos is null?  " + (previousMousePos == null) + ",   layerPanel.getEditorPalette().getCurrentSelection() class?  " + layerPanel.getEditorPalette().getCurrentSelection().getClass().getCanonicalName());
			return;
		}
		
		Point currentMousePos = new Point(e.getX(), e.getY());
		
		int xMove = currentMousePos.x - previousMousePos.x;
		int yMove = currentMousePos.y - previousMousePos.y;
		
		ArrayList<ScreenObject> selectedObjects = new ArrayList<ScreenObject>();
		
		ScreenObject so = null;
		
		for(int i = 0; i < layerPanel.getCommentaryLayerScreenObjects().size(); i++) {
			so = layerPanel.getCommentaryLayerScreenObjects().get(i);
			if(so.isSelected()) {
				if(so instanceof MobileScreenObject) {
					((MobileScreenObject)so).move(xMove, yMove);
				} else {
					so.getClickRect().move(xMove, yMove);
				}
			}
		}
		
		layerPanel.repaint();
		
	}
	
	
	private void drawOnCommentLevel(MouseEvent e) {
		
		PaletteObject po = layerPanel.getEditorPalette().getCurrentSelection();
		
		Point pt = new Point(e.getX(), e.getY());
		
//		System.out.println("now in drawOnCommentLevel; po " + (po == null ? "null" : po.getClass().getCanonicalName()));
		
		if(po == null || (!(po instanceof WidgetScreenPaletteObject) 
				&& !(po instanceof ObjectSelectPaletteObject)
				&& !(po instanceof RadioScreenPaletteObject) 
				&& !(po instanceof StaticBlockPaletteObject)
				&& !(po instanceof DoorSourcePaletteObject)
				&& !(po instanceof DoorDestinationPaletteObject)))
			return;
		
		
		if(po instanceof WidgetScreenPaletteObject) {
			
			ScreenObject newbie = ((WidgetScreenPaletteObject) po).create(e.getX(), e.getY(), this);
			layerPanel.getCommentaryLayerScreenObjects().add(newbie);
			
		} else if(po instanceof ObjectSelectPaletteObject) {
			
			ScreenObject so;
			
			if(!e.isControlDown()) {
				layerPanel.unselectEverything();
			}
			
			 for(int i =0; i < layerPanel.getCommentaryLayerScreenObjects().size(); i++) {
				 so = layerPanel.getCommentaryLayerScreenObjects().get(i);
				 if(so.getClickRect().contains(pt)) {
					 so.setSelected(!so.isSelected());
//					 System.out.println("Yeap, you clicked an object and it OUGHT to be selected.");
				 }
			 }
			
		} else if(po instanceof RadioScreenPaletteObject) {
			
//			System.out.println("it's a radio!  Why aren't we making a new one...?");
			
			ScreenObject newbie = ((RadioScreenPaletteObject) po).create(e.getX(), e.getY(), this);
			layerPanel.getCommentaryLayerScreenObjects().add(newbie);
			
		} else if(po instanceof StaticBlockPaletteObject && ((StaticBlockPaletteObject) po).getBlockChar() == ' ') {
			
//			System.out.println("about to erase at " + e.getX() + ", " + e.getY());
			
			
			ArrayList<ScreenObject> candidatesForErasure = new ArrayList<ScreenObject>();
			ArrayList<ScreenObject> allScreenObjects = layerPanel.getCommentaryLayerScreenObjects();
			ArrayList<Integer> indexesForErasure = new ArrayList<Integer>();
			for(int i = 0; i < allScreenObjects.size(); i++) {
				if(allScreenObjects.get(i).getClickRect().contains(pt)) {
					candidatesForErasure.add(allScreenObjects.get(i));
					indexesForErasure.add(i);
				}
			}
			
//			System.out.println("BEFORE   size of allScreenObjects: " + allScreenObjects.size() + ", size of indexesForErasure: " + indexesForErasure.size() + ", size of allScreenObjects: " + allScreenObjects.size());
			
			if(indexesForErasure.size() == 1) {
				ScreenObject deleted = allScreenObjects.remove(indexesForErasure.get(0).intValue());
//				System.out.println("only erased one.");
				
				if(deleted instanceof DoorDestinationScreenObject) {
					((DoorDestinationScreenObject) deleted).informPaletteObjectOfDelete();
				}
				
			} else if(indexesForErasure.size() == 0) {
//				System.out.println("it was empty!");
				
			} else {
			
				int indexesToBeErased [] = DeleteSelectionWizard.selectDeletableObjects(indexesForErasure, candidatesForErasure);
				
				if(indexesToBeErased == null) {
//					System.out.println("indexes to be erased was null!");
					return;
				}
				
				ScreenObject tempSO;
				
				//TODO:  make the user select an object from the candidate list
				for(int i = indexesToBeErased.length - 1; i >= 0; i--) {
					tempSO = allScreenObjects.get(indexesToBeErased[i]);
					
					if(tempSO instanceof RadioScreenObject) {
						((RadioScreenPaletteObject)((RadioScreenObject)tempSO).getPaletteObject()).delete(tempSO);
					} else if(tempSO instanceof DoorDestinationScreenObject) {
						((DoorDestinationScreenObject)tempSO).informPaletteObjectOfDelete();
					}
					
					allScreenObjects.remove(indexesToBeErased[i]);
				}
			}
			
		} else if(po instanceof DoorSourcePaletteObject) {
			
//			System.out.println("before, commentary layer screen objects count: " + layerPanel.getCommentaryLayerScreenObjects().size());
			
			DoorSourceScreenObject newbie = (DoorSourceScreenObject) ((DoorSourcePaletteObject)po).create(e.getX(), e.getY(), this);
			layerPanel.getCommentaryLayerScreenObjects().add(newbie);
			
//			System.out.println("after, commentary layer screen objects count: " + layerPanel.getCommentaryLayerScreenObjects().size());
			
		} else if(po instanceof DoorDestinationPaletteObject) {
			
			if(((DoorDestinationPaletteObject)po).screenObjectAlreadyExists()) {
				JOptionPane.showMessageDialog(this, "Only one destination per door is allowed, and there is already a destination in this room.","Unable to create", JOptionPane.WARNING_MESSAGE);
				return;
			}
			
//			System.out.println("before2, commentary layer screen objects count: " + layerPanel.getCommentaryLayerScreenObjects().size());
			
			DoorDestinationScreenObject newbie = (DoorDestinationScreenObject) ((DoorDestinationPaletteObject) po).create(e.getX(), e.getY(), this);
			layerPanel.getCommentaryLayerScreenObjects().add(newbie);

//			System.out.println("after2, commentary layer screen objects count: " + layerPanel.getCommentaryLayerScreenObjects().size());
			
		} 
		
		ArrayMoveOver.ensureOrderIntegrity(layerPanel.getCommentaryLayerScreenObjects());
		
		layerPanel.repaint();
		
	}
	
	
	
	private void moveOnEnemyOrWidgetLevel(MouseEvent e) {
		//System.out.println("move on enemy layer!");
		
		PaletteObject po = layerPanel.getEditorPalette().getCurrentSelection();
		
		if(po == null || (!(po instanceof MobileScreenPaletteObject) && !(po instanceof RainbowBossScreenPaletteObject))) {
//			System.out.println("<><>DELME FORGET IT");
			return;
		}
		
		if(po instanceof RainbowBossScreenPaletteObject) {
			
			RainbowBossScreenPaletteObject ro = (RainbowBossScreenPaletteObject) po;
			
			if(ro.isSettingFlagPos()) {
				
				if(ro.getCreatedObject() == null) {
					ro.setSettingFlagPos(false);
				} else {
					ro.getCreatedObject().updateMousePosition(e.getX(), e.getY());
					layerPanel.repaint();
				}
				
			}
			
			
			return;
		}
		
		MobileScreenPaletteObject mpo = (MobileScreenPaletteObject) po;
		
		MobileScreenObject mso = mpo.getConstructedObject();
		if(mso == null) {
//			System.out.println("<><>DELME found the freaking problem...!");
			return;
		}
		
		
		IntRect msoRect = mso.getClickRect();
		Point msoCenter = msoRect.getCenter();
		
		switch(mpo.getMode()) {
		case MobileScreenPaletteObject.DEFAULT:
			return;
		case MobileScreenPaletteObject.SETTING_MIN:
			if(mso.isVertical()) {
				mso.setMin(Math.min(e.getY(), msoCenter.y));
			} else {
				mso.setMin(Math.min(e.getX(), msoCenter.x));
			}
			layerPanel.repaint();
			break;
		case MobileScreenPaletteObject.SETTING_MAX:
			if(mso.isVertical()) {
				mso.setMax(Math.max(e.getY(), msoCenter.y));
			} else {
				mso.setMax(Math.max(e.getX(), msoCenter.x));
			}
			layerPanel.repaint();
			break;
		}
		
		
	}
	
	
	private void rightClickOnEnemyLevel(MouseEvent e) {
//		System.out.println("now in rightClickOnEnemyLevel");
		
		boolean boolArray[] = checkToSeeIfMinMaxShouldBeEnabled();
		
		boolean shouldNotBeGrayed = boolArray[0];
		boolean hasSpeed = boolArray[1];
		
		changeMinMaxMenuItem.setEnabled(shouldNotBeGrayed);
		changeSpeedMenuItem.setEnabled(hasSpeed);
		changeDirectionMenuItem.setEnabled(shouldNotBeGrayed);
		
		if(shouldNotBeGrayed) {
			mobileObjectPopupMenu.show(this, e.getX(), e.getY());
		} else {
			ArrayList<ScreenObject> selectedObjects = layerPanel.getSelectedObjects();
			if(selectedObjects.size() != 1 || !(selectedObjects.get(0) instanceof RainbowBossScreenObject)) {
				//do nothing
			} else {
				
				bossObjectPopupMenu.show(this, e.getX(), e.getY());
				
			}
			
		}
		
	}
	
	
	private void clickOnEnemyLevel(MouseEvent e) {
		
//		System.out.println("click on enemy layer! popup: " + e.isPopupTrigger());
		
		if(e.isPopupTrigger() || e.getButton() == MouseEvent.BUTTON2 || e.getButton() == MouseEvent.BUTTON3) {
			rightClickOnEnemyLevel(e);
			return;
		}
		
		
		PaletteObject po = layerPanel.getEditorPalette().getCurrentSelection();
		
		Point pt = new Point(e.getX(), e.getY());
		
		if(po == null) {
			return;
		}
		
		if(po instanceof RedEnemyScreenPaletteObject) {
			ScreenObject newbie = ((RedEnemyScreenPaletteObject) po).create(e.getX(), e.getY(), this);
			layerPanel.getEnemyLayerScreenObjects().add(newbie);
		} else if(po instanceof BlueEnemyScreenPaletteObject) {
			ScreenObject newbie = ((BlueEnemyScreenPaletteObject) po).create(e.getX(), e.getY(), this);
			layerPanel.getEnemyLayerScreenObjects().add(newbie);
		} else if(po instanceof StaticBlockPaletteObject && ((StaticBlockPaletteObject)po).getBlockChar() == ' ') {
//			System.out.println("about to erase at " + e.getX() + ", " + e.getY());
			
			
			ArrayList<ScreenObject> candidatesForErasure = new ArrayList<ScreenObject>();
			ArrayList<ScreenObject> allScreenObjects = layerPanel.getEnemyLayerScreenObjects();
			ArrayList<Integer> indexesForErasure = new ArrayList<Integer>();
			for(int i = 0; i < allScreenObjects.size(); i++) {
				if(allScreenObjects.get(i).getClickRect().contains(pt)) {
					candidatesForErasure.add(allScreenObjects.get(i));
					indexesForErasure.add(i);
				}
			}
			
//			System.out.println("BEFORE   size of allScreenObjects: " + allScreenObjects.size() + ", size of indexesForErasure: " + indexesForErasure.size() + ", size of allScreenObjects: " + allScreenObjects.size());
			
			if(indexesForErasure.size() == 1) {
				allScreenObjects.remove(indexesForErasure.get(0).intValue());
//				System.out.println("only erased one.");
				
				
			} else if(indexesForErasure.size() == 0) {
//				System.out.println("it was empty!");
				
			} else {
			
				int indexesToBeErased [] = DeleteSelectionWizard.selectDeletableObjects(indexesForErasure, candidatesForErasure);
				
				if(indexesToBeErased == null) {
//					System.out.println("indexes to be erased was null!");
					return;
				}
				
				ScreenObject tempSO;
				
				//TODO:  make the user select an object from the candidate list
				for(int i = indexesToBeErased.length - 1; i >= 0; i--) {
					tempSO = allScreenObjects.get(i);
					
					if(tempSO instanceof RogueBlockScreenObject) {
						((RogueBlockScreenPaletteObject)((RogueBlockScreenObject)tempSO).getPaletteObject()).delete(tempSO);
					} else if(tempSO instanceof VerticalBlockScreenObject) {
						((VerticalBlockScreenPaletteObject)((VerticalBlockScreenObject)tempSO).getPaletteObject()).delete(tempSO);
					} else if(tempSO instanceof HorizontalBlockScreenObject) {
						((HorizontalBlockScreenPaletteObject)((HorizontalBlockScreenObject)tempSO).getPaletteObject()).delete(tempSO);
					} else if(tempSO instanceof RainbowBossScreenObject) {
						((RainbowBossScreenObject) tempSO).getPaletteObject().screenObjectDeleted();
					}
					
					allScreenObjects.remove(indexesToBeErased[i]);
				}
			}
		} else if(po instanceof ObjectSelectPaletteObject) {
			
			ScreenObject so;
			
			if(!e.isControlDown()) {
				layerPanel.unselectEverything();
			}
			
			 for(int i =0; i < layerPanel.getEnemyLayerScreenObjects().size(); i++) {
				 so = layerPanel.getEnemyLayerScreenObjects().get(i);
				 if(so.getClickRect().contains(pt)) {
					 so.setSelected(!so.isSelected());
				 }
			 }
			
		} else if(po instanceof MobileScreenPaletteObject) {
			
			MobileScreenPaletteObject mpo = (MobileScreenPaletteObject) po;
			
			MobileScreenObject mso = mpo.getConstructedObject();
			
			
			switch(mpo.getMode()) {
			case MobileScreenPaletteObject.DEFAULT:
				mso = (MobileScreenObject) mpo.create(e.getX(), e.getY(), this);
				layerPanel.getEnemyLayerScreenObjects().add(mso);
				break;
			case MobileScreenPaletteObject.SETTING_MIN:
				mpo.setMode(MobileScreenPaletteObject.SETTING_MAX);
				break;
			case MobileScreenPaletteObject.SETTING_MAX:
				mpo.setMode(MobileScreenPaletteObject.DEFAULT);
				if(mpo.isSettingFromSelector()) {
					mpo.setSettingFromSelector(false);
					layerPanel.getEditorPalette().setSelectionToSelector();
				}
				break;
			}
			
//			System.out.println("at the end the mode is: " + mpo.getMode());
		} else if(po instanceof RainbowBossScreenPaletteObject) {
			
			if(((RainbowBossScreenPaletteObject) po).isSettingFlagPos()) {
				
				
				((RainbowBossScreenPaletteObject) po).setSettingFlagPos(false);
				
				if(((RainbowBossScreenPaletteObject) po).getCreatedObject() != null) {
					((RainbowBossScreenPaletteObject) po).getCreatedObject().updateMousePosition(e.getX(), e.getY());
				}
					
				
			} else {
			
				ScreenObject newbie = ((RainbowBossScreenPaletteObject) po).create(e.getX(), e.getY(), this);
				if(newbie == null) {
					JOptionPane.showMessageDialog(null, "There can only be one boss per room, sorry.","Warning", JOptionPane.WARNING_MESSAGE);
				} else {
					layerPanel.getEnemyLayerScreenObjects().add(newbie);
					
					((RainbowBossScreenPaletteObject) po).setSettingFlagPos(true);
					
					
				}
			}
		} else if(po instanceof RogueBlockScreenPaletteObject) {
//			System.out.println("about to make a rogue block at " + e.getX() + "," + e.getY());
			ScreenObject newbie = ((RogueBlockScreenPaletteObject) po).create(e.getX(), e.getY(), this);
			layerPanel.getEnemyLayerScreenObjects().add(newbie);
		} else if(po instanceof ConveyorPaletteObject) {
			ScreenObject newbie = ((ConveyorPaletteObject) po).create(e.getX(), e.getY(), this);
			layerPanel.getEnemyLayerScreenObjects().add(newbie);
		}
		
		ArrayMoveOver.ensureOrderIntegrity(layerPanel.getEnemyLayerScreenObjects());
		
		layerPanel.repaint();
		
	}
	
	private void dragOnEnemyLevel(MouseEvent e) {
//		System.out.println("drag on enemy level!");
		
		if(previousMousePos == null || (layerPanel.getEditorPalette().getCurrentSelection() != null && !(layerPanel.getEditorPalette().getCurrentSelection() instanceof ObjectSelectPaletteObject))) {
			//System.out.println("previousMousePos is null?  " + (previousMousePos == null) + ",   layerPanel.getEditorPalette().getCurrentSelection() class?  " + layerPanel.getEditorPalette().getCurrentSelection().getClass().getCanonicalName());
			return;
		}
		
		Point currentMousePos = new Point(e.getX(), e.getY());
		
		int xMove = currentMousePos.x - previousMousePos.x;
		int yMove = currentMousePos.y - previousMousePos.y;
		
		ArrayList<ScreenObject> selectedObjects = new ArrayList<ScreenObject>();
		
		ScreenObject so = null;
		
		for(int i = 0; i < layerPanel.getEnemyLayerScreenObjects().size(); i++) {
			so = layerPanel.getEnemyLayerScreenObjects().get(i);
			if(so.isSelected()) {
				if(so instanceof MobileScreenObject) {
					((MobileScreenObject)so).move(xMove, yMove);
				} else {
					so.getClickRect().move(xMove, yMove);
				}
			}
		}
		
		layerPanel.repaint();
		
	}
	
	
	
	private void dragOnDoorWidgetItemLevel(MouseEvent e) {
		
		if(e.isPopupTrigger()  || e.getButton() == MouseEvent.BUTTON2 || e.getButton() == MouseEvent.BUTTON3) {
			doorObjectPopupMenu.show(this, e.getX(), e.getY());
			return;
		}
		
		if(previousMousePos == null || !(layerPanel.getEditorPalette().getCurrentSelection() instanceof ObjectSelectPaletteObject))
			return;
		
		Point currentMousePos = new Point(e.getX(), e.getY());
		
		int xMove = currentMousePos.x - previousMousePos.x;
		int yMove = currentMousePos.y - previousMousePos.y;
		
		ArrayList<ScreenObject> selectedObjects = new ArrayList<ScreenObject>();
		
		ScreenObject so = null;
		
		for(int i = 0; i < layerPanel.getDoorLayerScreenObjects().size(); i++) {
			so = layerPanel.getDoorLayerScreenObjects().get(i);
			if(so.isSelected()) {
				so.getClickRect().move(xMove, yMove);
			}
		}
		
		layerPanel.repaint();
	}
	
	private void drawDoorWidgetItemOntoCanvas(MouseEvent e) {
		
//		System.out.println("e.isPopupTrigger()?  " + e.isPopupTrigger());
		if(e.isPopupTrigger() || e.getButton() == MouseEvent.BUTTON2 || e.getButton() == MouseEvent.BUTTON3) {
			doorObjectPopupMenu.show(this, e.getX(), e.getY());
			return;
		}
		
		
		PaletteObject paletteObject = layerPanel.getEditorPalette().getCurrentSelection();
		Point pt = new Point(e.getX(), e.getY());
		
		if(paletteObject == null)
			return;
		
		
		
		if(paletteObject instanceof HeartScreenPaletteObject) {
			HeartScreenObject newbie = (HeartScreenObject) ((HeartScreenPaletteObject) paletteObject).create(e.getX(), e.getY(), this);
			layerPanel.getDoorLayerScreenObjects().add(newbie);
//			System.out.println("about to add a heart at " + e.getX() + ", " + e.getY());
		} else if(paletteObject instanceof FlagScreenPaletteObject) {
			FlagScreenObject newbie = (FlagScreenObject) ((FlagScreenPaletteObject)paletteObject).create(e.getX(), e.getY(), this);
			layerPanel.getDoorLayerScreenObjects().add(newbie);
		} else if(paletteObject instanceof StaticBlockPaletteObject && ((StaticBlockPaletteObject)paletteObject).getBlockChar() == ' ') {
			
//			System.out.println("about to erase at " + e.getX() + ", " + e.getY());
			
			
			ArrayList<ScreenObject> candidatesForErasure = new ArrayList<ScreenObject>();
			ArrayList<ScreenObject> allScreenObjects = layerPanel.getDoorLayerScreenObjects();
			ArrayList<Integer> indexesForErasure = new ArrayList<Integer>();
			for(int i = 0; i < allScreenObjects.size(); i++) {
				if(allScreenObjects.get(i).getClickRect().contains(pt)) {
					candidatesForErasure.add(allScreenObjects.get(i));
					indexesForErasure.add(i);
				}
			}
			
//			System.out.println("BEFORE   size of allScreenObjects: " + allScreenObjects.size() + ", size of indexesForErasure: " + indexesForErasure.size() + ", size of allScreenObjects: " + allScreenObjects.size());
			
			DoorDestinationScreenObject deletedDest = null;
			
			if(indexesForErasure.size() == 1) {
				
				
				ScreenObject deleted = allScreenObjects.remove(indexesForErasure.get(0).intValue());
//				System.out.println("only erased one.");
				
				if(deleted instanceof DoorDestinationScreenObject) {
					deletedDest = (DoorDestinationScreenObject) deleted;
					deletedDest.informPaletteObjectOfDelete();
					deletedDest.updateSourceRoomListItemColor();
				}
				
				
			} else if(indexesForErasure.size() == 0) {
//				System.out.println("it was empty!");
				
			} else {
			
				int indexesToBeErased [] = DeleteSelectionWizard.selectDeletableObjects(indexesForErasure, candidatesForErasure);
				
				if(indexesToBeErased == null) {
//					System.out.println("indexes to be erased was null!");
					return;
				}
				
				//TODO:  make the user select an object from the candidate list
				for(int i = indexesToBeErased.length - 1; i >= 0; i--) {
					deletedDest = null;
					if(allScreenObjects.get(indexesToBeErased[i]) instanceof WidgetScreenObject) {
						((WidgetScreenObject) allScreenObjects.get(indexesToBeErased[i])).getPaletteObject().delete(allScreenObjects.get(indexesToBeErased[i]));
					} else if(allScreenObjects.get(indexesToBeErased[i]) instanceof DoorDestinationScreenObject) {
						deletedDest = ((DoorDestinationScreenObject) allScreenObjects.get(indexesToBeErased[i]));
					}
					allScreenObjects.remove(indexesToBeErased[i]);
					if(deletedDest != null)
						deletedDest.updateSourceRoomListItemColor();
				}
			}
			
//			System.out.println("AFTER   size of allScreenObjects: " + allScreenObjects.size() + ", size of indexesForErasure: " + indexesForErasure.size() + ", size of allScreenObjects: " + allScreenObjects.size());
			
		} else if(paletteObject instanceof WidgetScreenPaletteObject) {
			WidgetScreenObject newbie = (WidgetScreenObject) ((WidgetScreenPaletteObject) paletteObject).create(e.getX(), e.getY(), this);
			layerPanel.getDoorLayerScreenObjects().add(newbie);
//			System.out.println("about to add a widget at " + e.getX() + ", " + e.getY());
		} else if(paletteObject instanceof ObjectSelectPaletteObject) {
			
			ScreenObject so;
			
			if(!e.isControlDown()) {
				layerPanel.unselectEverything();
			}
			
			 for(int i =0; i < layerPanel.getDoorLayerScreenObjects().size(); i++) {
				 so = layerPanel.getDoorLayerScreenObjects().get(i);
				 if(so.getClickRect().contains(pt)) {
					 so.setSelected(!so.isSelected());
				 }
			 }
			
		} else if(paletteObject instanceof DoorSourcePaletteObject) {
			DoorSourceScreenObject newbie = (DoorSourceScreenObject) ((DoorSourcePaletteObject)paletteObject).create(e.getX(), e.getY(), this);
			layerPanel.getDoorLayerScreenObjects().add(newbie);
			
		} else if(paletteObject instanceof DoorDestinationPaletteObject) {
			
			if(((DoorDestinationPaletteObject)paletteObject).screenObjectAlreadyExists()) {
				JOptionPane.showMessageDialog(this, "Only one destination per door is allowed, and there is already a destination in this room.","Unable to create", JOptionPane.WARNING_MESSAGE);
				return;
			}
			
			DoorDestinationScreenObject newbie = (DoorDestinationScreenObject) ((DoorDestinationPaletteObject) paletteObject).create(e.getX(), e.getY(), this);
			layerPanel.getDoorLayerScreenObjects().add(newbie);
			newbie.updateSourceRoomListItemColor();
		} 
		
		ArrayMoveOver.ensureOrderIntegrity(layerPanel.getDoorLayerScreenObjects());
		
		layerPanel.repaint();
		layerPanel.getListItem().updateIconAndColor();
		
	}
	
	private void drawStaticBlockOntoCanvas(MouseEvent e) {

		Point p = layerPanel.getStaticBlockFactory().translateClickXYtoBlockXY(e.getX(), e.getY());
		
//		JOptionPane.showMessageDialog(null, "Click happened at: " + e.getX() + ", " + e.getY() + "; and the X and Y in terms of the blocks are: " + p.x + "," + p.y);
		
		
		
		if(layerPanel.getEditorPalette().getCurrentSelection() != null 
				&& layerPanel.getEditorPalette().getCurrentSelection() instanceof StaticBlockPaletteObject) {
			
			if(p.y >= staticBlockMap.length || p.x >= staticBlockMap[p.y].length || p.y < 0 || p.x < 0)
				return;
			
			staticBlockMap[p.y][p.x] = ((StaticBlockPaletteObject) layerPanel.getEditorPalette().getCurrentSelection()).getBlockChar();
			repaint();
		}
		
		
	}
	
	

	public void useBlockBrushCursor() {
		this.setCursor(blockBrushCursor);
	}
	
	public void useBlockEraserCursor() {
		this.setCursor(blockEraserCursor);
	}
	
	public void useDefaultCursor() {
		this.setCursor(Cursor.getDefaultCursor());
	}
	
	public void useWidgetBrushCursor() {
		this.setCursor(widgetBrushCursor);
	}
	
	public void useDoorBrushCursor() {
		this.setCursor(doorBrushCursor);
	}
	
	public void useCrossHeirsBrushCursor() {
		this.setCursor(crossheirsBrushCursor);
	}
	
	public void useDoorEraserCursor() {
		this.setCursor(widgetEraserCursor);
	}
	
	public void useDoorArrowCursor() {
		this.setCursor(widgetArrowCursor);
	}

	public void useRadioBrushCursor() {
		this.setCursor(radioBrushCursor);
	}
	
	public void useRadioEraserCursor() {
		this.setCursor(radioEraserCursor);
	}
	
	public void useRadioArrowCursor() {
		this.setCursor(radioArrowCursor);
	}
	
	public void useEnemyArrowCursor() {
		this.setCursor(enemyArrowCursor);
	}
	
	public void useEnemyBrushCursor() {
		this.setCursor(enemyBrushCursor);
	}
	
	public void useEnemyEraserCursor() {
		this.setCursor(enemyEraserCursor);
	}
	
	public void useUmbrellaArrowCursor() {
		this.setCursor(umbrellaArrowCursor);
	}
	
	public void useUmbrellaBrushCursor() {
		this.setCursor(umbrellaBrushCursor);
	}
	
	public void useUmbrellaEraserCursor() {
		this.setCursor(umbrellaEraserCursor);
	}
	
	public void useHurtzoneBrushCursor() {
//		System.out.println("<><>DELME using hurtzone bursh cursor...wait, issit null? " + (hurtzoneBrushCursor == null));
		this.setCursor(hurtzoneBrushCursor);
	}
	
	
	public Point determineCenterOfViewport() {
		if(scrollPane == null) {
			return null;
		} else {
			Rectangle rect = scrollPane.getViewport().getViewRect();
			int avgX = (int) (rect.getMaxX() + rect.getMinX()) / 2;
			int avgY = (int) (rect.getMaxY() + rect.getMinY()) / 2;
			return new Point(avgX, avgY);
		}
	}
	
	
	public boolean newDimensionsWouldEraseStuff(int newWidth, int newHeight) {
		
		if(staticBlockMap == null || (staticBlockMap.length <= newHeight && staticBlockMap[0] != null && staticBlockMap[0].length <= newWidth))
			return false;
		
		char [] subArray;
		for(int y = 0; y < staticBlockMap.length; y++) {
			
			subArray = staticBlockMap[y];
			if(subArray == null)
				continue;
			
			for(int x = 0; x < subArray.length; x++) {
				if((x >= newWidth || y >= newHeight) && subArray[x] != ' ' )
					return true;
			}
		}
		
		return false;
	}
	
	public void changeDimensions(int newWidth, int newHeight) {
		
		char newStaticBlockMap[][] = new char[newHeight][];
		
		char tempDestinationArray[];
		char tempSourceArray[];
		
		
		for(int y = 0; y < newHeight; y++) {
			tempDestinationArray = new char[newWidth];
			if(staticBlockMap.length > y) {
				
				tempSourceArray = staticBlockMap[y];
				
				for(int x = 0; x < newWidth; x++) {
					if(tempSourceArray.length > x) {
						tempDestinationArray[x] = tempSourceArray[x];
					} else {
						tempDestinationArray[x] = ' ';
					}
				}
				newStaticBlockMap[y] = tempDestinationArray;
				
			} else {
				for(int x = 0; x < newWidth; x++) {
					tempDestinationArray[x] = ' ';
				}
				newStaticBlockMap[y] = tempDestinationArray;
			}
		}
		
		staticBlockMap = newStaticBlockMap;
		scrollPane.revalidate();
	}
	
	
	public void reOpenNewRoomWizardForEdit() {
		
		
		int origTileWidth = layerPanel.getStaticBlockFactory().getTileWidth();
		int origTileHeight = layerPanel.getStaticBlockFactory().getTileHeight();
		int origRoomWidth = layerPanel.getStaticBlockFactory().getBlocksWide();
		int origRoomHeight = layerPanel.getStaticBlockFactory().getBlocksHigh();
		
		Color origUnusedColor = layerPanel.getStaticBlockFactory().getUnusedColor();
		Color origTransparentColor = layerPanel.getStaticBlockFactory().getTransparentColor();
		Color origOutOfBoundsColor = layerPanel.getStaticBlockFactory().getOutOfBoundsColor();
		
		String origBackgroundFileName = layerPanel.getStaticBlockFactory().getBackgroundFileName();
		String origForegroundFileName = layerPanel.getStaticBlockFactory().getForegroundFileName();
		String origRoomName = layerPanel.getStaticBlockFactory().getRoomName();
		
		JDialog wizardFrame = new JDialog();
		NewRoomSetupWizard wizard = new NewRoomSetupWizard(
				wizardFrame, origTileWidth, origTileHeight, origRoomWidth, origRoomHeight, 
				origUnusedColor, origTransparentColor, origOutOfBoundsColor, origBackgroundFileName, 
				origForegroundFileName, origRoomName, layerPanel.getMainEditorPanel(), this.layerPanel);
		
		wizardFrame.setContentPane(wizard);
		
		
		wizardFrame.setMinimumSize(new Dimension(600, 400));
		wizardFrame.setMaximumSize(new Dimension(600, 400));
		wizardFrame.setPreferredSize(new Dimension(600, 400));
		
		wizardFrame.setModal(true);
		
		wizardFrame.setVisible(true);
		
		if(wizard.wasCancelled()) {
//			System.out.println("cancel was hit!");
			return;
		}
		
		int newRoomWidth = wizard.getRoomWidth();
		int newRoomHeight = wizard.getRoomHeight();
		
		if(newDimensionsWouldEraseStuff(newRoomWidth, newRoomHeight)) {
//			System.out.println("it would erase stuff!");
			int confirmEraseBlocks = JOptionPane.showConfirmDialog(this, "Lowering the dimension(s) like this will erase some blocks.  Continue?","Confirm Dimension Shrinkage", JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE);
			if(confirmEraseBlocks == JOptionPane.NO_OPTION) {
				int confirmChangeTheRest = JOptionPane.showConfirmDialog(this, "Okay, so we don't lower the dimensions, but should the other changes stick?","Confirm Cancellation (no joke)", JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE);
				if(confirmChangeTheRest == JOptionPane.NO_OPTION)
					return;
				else {
					
//					System.out.println("<><>DELME about to update everything but the dimensions...");
					
					
					layerPanel.setStaticBlockFactory(new StaticBlockCanvasObjectFactory(wizard, this, true, layerPanel.getStaticBlockFactory().getBlocksWide(), layerPanel.getStaticBlockFactory().getBlocksHigh()));
					
//					canvasWidth = wizard.getTileWidth() * wizard.getRoomWidth();
//					canvasHeight = wizard.getTileHeight() * wizard.getRoomHeight();
//					
//					this.setMaximumSize(new Dimension(canvasWidth, canvasHeight));
//					this.setMinimumSize(new Dimension(canvasWidth, canvasHeight));
//					this.setPreferredSize(new Dimension(canvasWidth, canvasHeight));
				}
				
			} else {
//				System.out.println("<><>DELME about to update everything INCLUDING the dimensions...");
				
				
				layerPanel.setStaticBlockFactory(new StaticBlockCanvasObjectFactory(wizard, this));
				
				canvasWidth = wizard.getTileWidth() * wizard.getRoomWidth();
				canvasHeight = wizard.getTileHeight() * wizard.getRoomHeight();
				
				this.setMaximumSize(new Dimension(canvasWidth, canvasHeight));
				this.setMinimumSize(new Dimension(canvasWidth, canvasHeight));
				this.setPreferredSize(new Dimension(canvasWidth, canvasHeight));
				
				
				this.changeDimensions(wizard.getRoomWidth(), wizard.getRoomHeight());
				
			}
		} else {
//			System.out.println("so...it WOULDN'T erase anything?  How's that possible...?");
			
			
			
			
			
			layerPanel.setStaticBlockFactory(new StaticBlockCanvasObjectFactory(wizard, this));
			
			canvasWidth = wizard.getTileWidth() * wizard.getRoomWidth();
			canvasHeight = wizard.getTileHeight() * wizard.getRoomHeight();
			
			this.setMaximumSize(new Dimension(canvasWidth, canvasHeight));
			this.setMinimumSize(new Dimension(canvasWidth, canvasHeight));
			this.setPreferredSize(new Dimension(canvasWidth, canvasHeight));
			
			
			this.changeDimensions(wizard.getRoomWidth(), wizard.getRoomHeight());
		}
		
		layerPanel.repaint();
		
	}
	
	public int getCountOfStaticBlocks() {
		
		int returnValue = 0;
		
		if(staticBlockMap != null) {
			for(char[] row : staticBlockMap) {
				if(row != null) {
					for(char c : row) {
						if(c != ' ')
							returnValue++;
					}
				}
			}
		}
		
		return returnValue;
	}
	
	
	public boolean doorsShouldShowDestinationsAndSources() {
		return doorsShowDestinations.isSelected();
	}
	
	public char[][] getStaticBlockMap() {
		return staticBlockMap;
	}
	
	
	
	public void writeOutViewToImageFile() {
		
		FileDialog fd = new FileDialog(layerPanel.getFrame());
		fd.setMode(FileDialog.SAVE);
		fd.setModal(true);
		
		fd.setVisible(true);
		
		fd.dispose();
		
		if(fd.getFile() == null || fd.getDirectory() == null)
			return;
		
		String fileName = fd.getDirectory() + fd.getFile();
		
		if(!fileName.endsWith(".GIF") && !fileName.endsWith(".gif")) {
			fileName = fileName + ".GIF";
		}
		
		File outFile = new File(fileName);
		
		
		BufferedImage bi = new BufferedImage(layerPanel.getStaticBlockFactory().getBlocksWide() * layerPanel.getStaticBlockFactory().getTileWidth(), 
				layerPanel.getStaticBlockFactory().getBlocksHigh() * layerPanel.getStaticBlockFactory().getTileHeight(), BufferedImage.TYPE_INT_RGB);
		
		Graphics g = bi.getGraphics();
		
		this.paintComponent(g);
		
		g.dispose();
		
		try {
			ImageIO.write(bi, "GIF", outFile);
		} catch(Exception e) {
//			e.printStackTrace();
			JOptionPane.showMessageDialog(this, "Unable to write out the file: " + e.getMessage(),"Error occurred", JOptionPane.ERROR_MESSAGE);
		}
		
		
		
	}
	
	
}
